varying vec2 		texCoord;		// Center
uniform vec2		invSize;
uniform sampler2D 	hiresDepth,
					loresDepth,
					sourceImage,
					sobelImage;
					
float DEPTH_EPS=1.0;
					
float getWeigth(float fineD, vec2 uv)
{
	float coarseD=texture2D(loresDepth,uv).x;
	return 1.0/(DEPTH_EPS + abs(fineD-coarseD));
}
					
void	main()
{
	if(texture2D(sobelImage,texCoord).x>0.0)
	{
		float totWeight=0.0;
		vec4  finalColor=vec4(0.0);
		float weigth;
		float fineDepth=texture2D(hiresDepth,texCoord).x;
		for(int x=-2; x<=2; x++)
		{
			for(int y=-2; y<=2; y++)
			{
				vec2 uv=texCoord+vec2(x,y)*invSize;
				weigth=getWeigth(fineDepth, uv);
				finalColor += texture2D(sourceImage,uv)*weigth;
				totWeight+=weigth;
			}
		}
		gl_FragColor=finalColor/totWeight;
		return;
	}
	gl_FragColor=texture2D(sourceImage,texCoord);
}
